//--------------------------------------------------------------//
// Header
//
// Define : Name, Category, Subcategory, Notes, Flags
//--------------------------------------------------------------//
DeclareLightworksEffect( "Channel Extractor", "Colour", "User", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//
// For each 'texture' declared here, Lightworks adds a matching
// input to your effect (so for a four input effect, you'd need
// to delcare four textures and samplers)
//--------------------------------------------------------------

DeclareInput( Input );

//--------------------------------------------------------------
// Define parameters here.
//
// The Lightworks application will automatically generate
// sliders/controls for all parameters which do not start
// with a a leading '_' character
//
// If Lightworks encounters an int-based parameter called 'SetTechnique', it will be shown on the FX
// panel like any other parameter, but it will also implicitly choose an execution technique
// to match the user-selection (eg. if the user chooses 'Green' from the drop-down list,
// Lightworks will arrange for the 'Green' technique (at the bottom of this file) to be executed
// when the effect is rendered)
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Channel", kNoGroup, 0, "Red|Green|Blue|Alpha" );

//--------------------------------------------------------------
// Pixel Shader
//
// This section defines the code which the GPU will
// execute for every pixel in an output image.
//
// Note that pixels are processed out of order, in parallel.
// Using shader model 2.0, so there's a 64 instruction limit -
// use multple passes if you need more.
//--------------------------------------------------------------
DeclareEntryPoint( Red )
{
   float4 pixel = tex2D( Input, uv1 );
   return float4( pixel.r, pixel.r, pixel.r, 1 );
}

DeclareEntryPoint( Green )
{
   float4 pixel = tex2D( Input, uv1 );
   return float4( pixel.g, pixel.g, pixel.g, 1 );
}

DeclareEntryPoint( Blue )
{
   float4 pixel = tex2D( Input, uv1 );
   return float4( pixel.b, pixel.b, pixel.b, 1 );
}

DeclareEntryPoint( Alpha )
{
   float4 pixel = tex2D( Input, uv1 );
   return float4( pixel.a, pixel.a, pixel.a, 1 );
}
